-- pcmag database setup script

use master
go

-- create database log and data devices

create database pcmag on
	(name = pcmagdata,
	filename = 'f:\datadev.mdf',
	size = 6144 MB)
log on 
	(name = pcmaglog,
	filename = 'e:\logdev.ldf',
	size = 1024 MB)
go

checkpoint
go

-------
-- set database options

-- truncate log on checkpoint
sp_dboption 'pcmag', 'trunc. log on chkpt.', true
go
-- close cursors on commit or rollback (avoids having to manually close cursors)
sp_dboption 'pcmag', 'cursor close on commit', true
go
-- cursor scope is local to procedure in which the cursor is declared (avoids cursor redefinition error)
sp_dboption 'pcmag', 'default to local cursor', true
go

checkpoint
go
